
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="John_hours")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="Laura_hours")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="Hank_hours")


    # Set objective function
    model.setObjective(6*x0 + 6*x1 + 4*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7*x1 + 3*x2 >= 35, "c0")
    model.addConstr(13*x0 + 7*x1 >= 28, "c1")
    model.addConstr(13*x0 + 7*x1 + 3*x2 >= 28, "c2")
    model.addConstr(8*x0 + 7*x1 >= 29, "c3")
    model.addConstr(8*x0 + 2*x2 >= 13, "c4")
    model.addConstr(8*x0 + 7*x1 + 2*x2 >= 17, "c5")
    model.addConstr(13*x0 + 6*x2 >= 10, "c6")
    model.addConstr(13*x1 + 6*x2 >= 19, "c7")
    model.addConstr(13*x0 + 13*x1 >= 12, "c8")
    model.addConstr(13*x0 + 13*x1 + 6*x2 >= 12, "c9")
    model.addConstr(8*x1 + 3*x2 >= 24, "c10")
    model.addConstr(2*x0 + 8*x1 >= 21, "c11")
    model.addConstr(2*x0 + 3*x2 >= 23, "c12")
    model.addConstr(2*x0 + 8*x1 + 3*x2 >= 23, "c13")
    model.addConstr(12*x0 + 6*x1 >= 29, "c14")
    model.addConstr(12*x0 + 14*x2 >= 27, "c15")
    model.addConstr(6*x1 + 14*x2 >= 37, "c16")
    model.addConstr(12*x0 + 6*x1 + 14*x2 >= 40, "c17")
    model.addConstr(-10*x0 + 5*x2 >= 0, "c18")
    model.addConstr(8*x0 + 7*x1 + 2*x2 <= 68, "c19")
    model.addConstr(2*x0 + 3*x2 <= 62, "c20")
    model.addConstr(8*x1 + 3*x2 <= 72, "c21")
    model.addConstr(2*x0 + 8*x1 <= 47, "c22")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
