
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # hours worked by John
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Laura
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by Hank

    # Objective function
    model.setObjective(6 * x0 + 6 * x1 + 4 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7 * x1 + 3 * x2 >= 35)
    model.addConstr(13 * x0 + 7 * x1 >= 28)
    model.addConstr(13 * x0 + 7 * x1 + 3 * x2 >= 28)
    model.addConstr(8 * x0 + 7 * x1 >= 29)
    model.addConstr(8 * x0 + 2 * x2 >= 13)
    model.addConstr(8 * x0 + 7 * x1 + 2 * x2 >= 17)
    model.addConstr(8 * x0 + 7 * x1 + 2 * x2 >= 17)
    model.addConstr(13 * x0 + 6 * x2 >= 10)
    model.addConstr(13 * x1 + 6 * x2 >= 19)
    model.addConstr(13 * x0 + 13 * x1 >= 12)
    model.addConstr(13 * x0 + 13 * x1 + 6 * x2 >= 12)
    model.addConstr(8 * x1 + 3 * x2 >= 24)
    model.addConstr(2 * x0 + 8 * x1 >= 21)
    model.addConstr(2 * x0 + 3 * x2 >= 23)
    model.addConstr(2 * x0 + 8 * x1 + 3 * x2 >= 23)
    model.addConstr(12 * x0 + 6 * x1 >= 29)
    model.addConstr(12 * x0 + 14 * x2 >= 27)
    model.addConstr(6 * x1 + 14 * x2 >= 37)
    model.addConstr(12 * x0 + 6 * x1 + 14 * x2 >= 40)
    model.addConstr(12 * x0 + 6 * x1 + 14 * x2 >= 40)
    model.addConstr(-10 * x0 + 5 * x2 >= 0)
    model.addConstr(8 * x0 + 7 * x1 + 2 * x2 <= 68)
    model.addConstr(2 * x0 + 3 * x2 <= 62)
    model.addConstr(8 * x1 + 3 * x2 <= 72)
    model.addConstr(2 * x0 + 8 * x1 <= 47)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x0: ', x0.varValue)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
