
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrition_Optimization")

# Create variables
calcium = model.addVar(lb=0, name="calcium")
fat = model.addVar(lb=0, name="fat")
vitamin_b9 = model.addVar(lb=0, name="vitamin_b9")
vitamin_b1 = model.addVar(lb=0, name="vitamin_b1")


# Set objective function
model.setObjective(8.95 * calcium + 4.67 * fat + 9.76 * vitamin_b9 + 6.57 * vitamin_b1, GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * calcium + 6 * vitamin_b9 >= 21)
model.addConstr(6 * fat + 1 * vitamin_b1 >= 12)
model.addConstr(6 * vitamin_b9 + 1 * vitamin_b1 >= 8)
model.addConstr(6 * fat + 6 * vitamin_b9 >= 21)
model.addConstr(4 * calcium + 6 * fat + 1 * vitamin_b1 >= 13)
model.addConstr(4 * calcium + 6 * vitamin_b9 + 1 * vitamin_b1 >= 13)
model.addConstr(6 * fat + 6 * vitamin_b9 + 1 * vitamin_b1 >= 13)
model.addConstr(4 * calcium + 6 * fat + 1 * vitamin_b1 >= 14)
model.addConstr(4 * calcium + 6 * vitamin_b9 + 1 * vitamin_b1 >= 14)
model.addConstr(6 * fat + 6 * vitamin_b9 + 1 * vitamin_b1 >= 14)
model.addConstr(4 * calcium + 6 * fat + 1 * vitamin_b1 >= 15)
model.addConstr(4 * calcium + 6 * vitamin_b9 + 1 * vitamin_b1 >= 15)
model.addConstr(6 * fat + 6 * vitamin_b9 + 1 * vitamin_b1 >= 15)
model.addConstr(4 * calcium + 6 * fat + 6 * vitamin_b9 + 1 * vitamin_b1 >= 15)
model.addConstr(3 * calcium + 8 * vitamin_b1 >= 6)
model.addConstr(5 * vitamin_b9 + 8 * vitamin_b1 >= 7)
model.addConstr(4 * fat + 5 * vitamin_b9 >= 12)
model.addConstr(3 * calcium + 5 * vitamin_b9 + 8 * vitamin_b1 >= 18)
model.addConstr(3 * calcium + 4 * fat + 5 * vitamin_b9 + 8 * vitamin_b1 >= 18)
model.addConstr(8 * fat + 4 * vitamin_b1 >= 19)
model.addConstr(6 * calcium + 8 * fat >= 17)
model.addConstr(8 * fat + 6 * vitamin_b9 >= 8)
model.addConstr(6 * vitamin_b9 + 4 * vitamin_b1 >= 20)
model.addConstr(6 * calcium + 6 * vitamin_b9 + 4 * vitamin_b1 >= 14)
model.addConstr(6 * calcium + 8 * fat + 4 * vitamin_b1 >= 14)
model.addConstr(6 * calcium + 8 * fat + 6 * vitamin_b9 >= 14)
model.addConstr(6 * calcium + 6 * vitamin_b9 + 4 * vitamin_b1 >= 13)
model.addConstr(6 * calcium + 8 * fat + 4 * vitamin_b1 >= 13)
model.addConstr(6 * calcium + 8 * fat + 6 * vitamin_b9 >= 13)
model.addConstr(6 * calcium + 6 * vitamin_b9 + 4 * vitamin_b1 >= 11)
model.addConstr(6 * calcium + 8 * fat + 4 * vitamin_b1 >= 11)
model.addConstr(6 * calcium + 8 * fat + 6 * vitamin_b9 >= 11)
model.addConstr(6 * calcium + 8 * fat + 6 * vitamin_b9 + 4 * vitamin_b1 >= 11)
model.addConstr(10 * calcium - 5 * fat >= 0)
model.addConstr(10 * fat - 8 * vitamin_b1 >= 0)
model.addConstr(4 * calcium + 6 * vitamin_b9 + 1 * vitamin_b1 <= 69)
model.addConstr(6 * fat + 6 * vitamin_b9 + 1 * vitamin_b1 <= 49)
model.addConstr(4 * calcium + 6 * fat + 6 * vitamin_b9 <= 66)
model.addConstr(4 * calcium + 6 * fat + 1 * vitamin_b1 <= 27)
model.addConstr(3 * calcium + 4 * fat <= 55)
model.addConstr(3 * calcium + 4 * fat + 5 * vitamin_b9 <= 44)
model.addConstr(4 * fat + 5 * vitamin_b9 + 8 * vitamin_b1 <= 62)
model.addConstr(6 * calcium + 4 * vitamin_b1 <= 23)
model.addConstr(6 * calcium + 6 * vitamin_b9 <= 60)
model.addConstr(6 * calcium + 8 * fat + 4 * vitamin_b1 <= 61)

# Resource Constraints
model.addConstr(4 * calcium + 6 * fat + 6 * vitamin_b9 + 1 * vitamin_b1 <= 84)
model.addConstr(3 * calcium + 4 * fat + 5 * vitamin_b9 + 8 * vitamin_b1 <= 78)
model.addConstr(6 * calcium + 8 * fat + 6 * vitamin_b9 + 4 * vitamin_b1 <= 82)



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Objective Value:', model.objVal)
    print('Calcium:', calcium.x)
    print('Fat:', fat.x)
    print('Vitamin B9:', vitamin_b9.x)
    print('Vitamin B1:', vitamin_b1.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

