
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of calcium")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="grams of fat")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of vitamin B9")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams of vitamin B1")

    # Objective function
    model.setObjective(8.95 * x0 + 4.67 * x1 + 9.76 * x2 + 6.57 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x0 <= 84)
    model.addConstr(6 * x1 <= 84)
    model.addConstr(6 * x2 <= 84)
    model.addConstr(x3 <= 84)
    model.addConstr(4 * x0 + 6 * x2 >= 21)
    model.addConstr(6 * x1 + x3 >= 12)
    model.addConstr(6 * x2 + x3 >= 8)
    model.addConstr(6 * x1 + 6 * x2 >= 21)
    model.addConstr(4 * x0 + 6 * x1 + x3 >= 13)
    model.addConstr(4 * x0 + 6 * x2 + x3 >= 13)
    model.addConstr(6 * x1 + 6 * x2 + x3 >= 13)
    model.addConstr(4 * x0 + 6 * x1 + x3 >= 14)
    model.addConstr(4 * x0 + 6 * x2 + x3 >= 14)
    model.addConstr(6 * x1 + 6 * x2 + x3 >= 14)
    model.addConstr(4 * x0 + 6 * x1 + x3 >= 15)
    model.addConstr(4 * x0 + 6 * x2 + x3 >= 15)
    model.addConstr(6 * x1 + 6 * x2 + x3 >= 15)
    model.addConstr(4 * x0 + 6 * x1 + 6 * x2 + x3 >= 15)
    model.addConstr(3 * x0 + 8 * x3 >= 6)
    model.addConstr(5 * x2 + 8 * x3 >= 7)
    model.addConstr(4 * x1 + 5 * x2 >= 12)
    model.addConstr(3 * x0 + 5 * x2 + 8 * x3 >= 18)
    model.addConstr(3 * x0 + 4 * x1 + 5 * x2 + 8 * x3 >= 18)
    model.addConstr(8 * x1 + 4 * x3 >= 19)
    model.addConstr(3 * x0 + 8 * x1 >= 17)
    model.addConstr(8 * x1 + 6 * x2 >= 8)
    model.addConstr(6 * x2 + 4 * x3 >= 20)
    model.addConstr(3 * x0 + 6 * x2 + 4 * x3 >= 14)
    model.addConstr(3 * x0 + 8 * x1 + 4 * x3 >= 14)
    model.addConstr(3 * x0 + 8 * x1 + 6 * x2 >= 14)
    model.addConstr(3 * x0 + 6 * x2 + 4 * x3 >= 13)
    model.addConstr(3 * x0 + 8 * x1 + 4 * x3 >= 13)
    model.addConstr(3 * x0 + 8 * x1 + 6 * x2 >= 13)
    model.addConstr(3 * x0 + 6 * x2 + 4 * x3 >= 11)
    model.addConstr(3 * x0 + 8 * x1 + 4 * x3 >= 11)
    model.addConstr(3 * x0 + 8 * x1 + 6 * x2 >= 11)
    model.addConstr(3 * x0 + 8 * x1 + 6 * x2 + 4 * x3 >= 11)
    model.addConstr(10 * x0 - 5 * x1 >= 0)
    model.addConstr(10 * x1 - 8 * x3 >= 0)
    model.addConstr(4 * x0 + 6 * x2 + x3 <= 69)
    model.addConstr(6 * x1 + 6 * x2 + x3 <= 49)
    model.addConstr(4 * x0 + 6 * x1 + 6 * x2 <= 66)
    model.addConstr(4 * x0 + 6 * x1 + x3 <= 27)
    model.addConstr(3 * x0 + 4 * x1 <= 55)
    model.addConstr(3 * x0 + 4 * x1 + 5 * x2 <= 44)
    model.addConstr(4 * x1 + 5 * x2 + 8 * x3 <= 62)
    model.addConstr(3 * x0 + 4 * x3 <= 23)
    model.addConstr(3 * x0 + 6 * x2 <= 60)
    model.addConstr(3 * x0 + 8 * x1 + 4 * x3 <= 61)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Milligrams of calcium: ", x0.varValue)
        print("Grams of fat: ", x1.varValue)
        print("Milligrams of vitamin B9: ", x2.varValue)
        print("Milligrams of vitamin B1: ", x3.varValue)
        print("Objective function value: ", model.objVal)
    else:
        print("No optimal solution found.")

optimization_problem()
