
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by George
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1")  # hours worked by Paul
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Peggy
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")  # hours worked by Laura


    # Set objective function
    m.setObjective(4.45 * x0 + 9.77 * x1 + 6.93 * x2 + 9.48 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10 * x0 + 9 * x2 >= 19)
    m.addConstr(9 * x2 + 9 * x3 >= 34)
    m.addConstr(12 * x1 + 9 * x2 + 9 * x3 >= 42)
    m.addConstr(10 * x0 + 9 * x2 + 9 * x3 >= 42)
    m.addConstr(12 * x1 + 9 * x2 + 9 * x3 >= 24)
    m.addConstr(10 * x0 + 9 * x2 + 9 * x3 >= 24)
    m.addConstr(-8 * x1 + 3 * x3 >= 0)
    m.addConstr(10 * x0 + 12 * x3 <= 21)
    m.addConstr(8 * x1 + 5 * x2 <= 32)
    m.addConstr(10 * x0 + 8 * x1 <= 40)
    m.addConstr(10 * x0 + 8 * x1 + 5 * x2 + 12 * x3 <= 40)
    m.addConstr(12 * x1 + 9 * x3 <= 113)
    m.addConstr(10 * x0 + 9 * x3 <= 71)
    m.addConstr(12 * x1 + 9 * x2 <= 142)
    m.addConstr(10 * x0 + 12 * x1 + 9 * x2 + 9 * x3 <= 142)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
