
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by George
x1 = m.addVar(name="x1", lb=0, integrality=gp.GRB.INTEGER)  # hours worked by Paul
x2 = m.addVar(name="x2", lb=0)  # hours worked by Peggy
x3 = m.addVar(name="x3", lb=0)  # hours worked by Laura

# Objective function
m.setObjective(4.45*x0 + 9.77*x1 + 6.93*x2 + 9.48*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(10*x0 <= 80, name="r0_George")
m.addConstr(10*x0 <= 169, name="r1_George")
m.addConstr(8*x1 <= 80, name="r0_Paul")
m.addConstr(12*x1 <= 169, name="r1_Paul")
m.addConstr(5*x2 <= 80, name="r0_Peggy")
m.addConstr(9*x2 <= 169, name="r1_Peggy")
m.addConstr(12*x3 <= 80, name="r0_Laura")
m.addConstr(9*x3 <= 169, name="r1_Laura")

m.addConstr(10*x0 + 9*x2 >= 19, name="prod_George_Peggy")
m.addConstr(9*x2 + 9*x3 >= 34, name="prod_Peggy_Laura")
m.addConstr(12*x1 + 9*x2 + 9*x3 >= 42, name="prod_Paul_Peggy_Laura")
m.addConstr(10*x0 + 9*x2 + 9*x3 >= 42, name="prod_George_Peggy_Laura")
m.addConstr(12*x1 + 9*x2 + 9*x3 >= 24, name="prod_Paul_Peggy_Laura_2")
m.addConstr(10*x0 + 9*x2 + 9*x3 >= 24, name="prod_George_Peggy_Laura_2")
m.addConstr(-8*x1 + 3*x3 >= 0, name="paul_laura_constraint")
m.addConstr(10*x0 + 12*x3 <= 21, name="quit_George_Laura")
m.addConstr(8*x1 + 5*x2 <= 32, name="quit_Paul_Peggy")
m.addConstr(10*x0 + 8*x1 <= 40, name="quit_George_Paul")
m.addConstr(10*x0 + 8*x1 + 5*x2 + 12*x3 <= 40, name="quit_all")
m.addConstr(12*x1 + 9*x3 <= 113, name="prod_Paul_Laura")
m.addConstr(10*x0 + 9*x3 <= 71, name="prod_George_Laura")
m.addConstr(12*x1 + 9*x2 <= 142, name="prod_Paul_Peggy")
m.addConstr(10*x0 + 12*x1 + 9*x2 + 9*x3 <= 142, name="prod_all")

# Solve the model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found")
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("No optimal solution found")
