
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
bobby = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby")
george = m.addVar(vtype=gp.GRB.INTEGER, name="george")
laura = m.addVar(vtype=gp.GRB.INTEGER, name="laura")


# Set objective function
m.setObjective(6.92 * hank + 4.83 * bobby + 4.38 * george + 2.46 * laura, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.72 * bobby + 2.72 * george >= 26)
m.addConstr(2.8 * hank + 2.72 * george >= 74)
m.addConstr(2.8 * hank + 2.72 * george + 0.01 * laura >= 56)
m.addConstr(3.72 * bobby + 2.72 * george + 0.01 * laura >= 56)
m.addConstr(2.8 * hank + 3.72 * bobby + 2.72 * george >= 56)
m.addConstr(2.8 * hank + 2.72 * george + 0.01 * laura >= 62)
m.addConstr(3.72 * bobby + 2.72 * george + 0.01 * laura >= 62)
m.addConstr(2.8 * hank + 3.72 * bobby + 2.72 * george >= 62)
m.addConstr(2.8 * hank + 2.72 * george + 0.01 * laura >= 53)
m.addConstr(3.72 * bobby + 2.72 * george + 0.01 * laura >= 53)
m.addConstr(2.8 * hank + 3.72 * bobby + 2.72 * george >= 53)
m.addConstr(2.8 * hank + 3.72 * bobby + 2.72 * george + 0.01 * laura >= 53)
m.addConstr(0.33 * bobby + 2.36 * george >= 38)
m.addConstr(4.85 * hank + 1.19 * laura >= 46)
m.addConstr(4.85 * hank + 2.36 * george >= 47)
m.addConstr(4.85 * hank + 0.33 * bobby + 2.36 * george >= 47)
m.addConstr(0.33 * bobby + 2.36 * george + 1.19 * laura >= 47)
m.addConstr(4.85 * hank + 0.33 * bobby + 2.36 * george >= 46)
m.addConstr(0.33 * bobby + 2.36 * george + 1.19 * laura >= 46)
m.addConstr(4.85 * hank + 0.33 * bobby + 2.36 * george + 1.19 * laura >= 46)
m.addConstr(1.37 * hank + 2.72 * george >= 38)  # Corrected: Using george's likelihood to quit index (resource r2, x2)
m.addConstr(4.96 * george + 4.27 * laura >= 22)
m.addConstr(5.56 * bobby + 4.96 * george >= 30)
m.addConstr(5.56 * bobby + 4.27 * laura >= 37)
m.addConstr(1.37 * hank + 4.27 * laura >= 31)
m.addConstr(1.37 * hank + 5.56 * bobby >= 20)
m.addConstr(1.37 * hank + 5.56 * bobby + 4.96 * george + 4.27 * laura >= 20)
m.addConstr(2.09 * george + 1.11 * laura >= 57)
m.addConstr(4.63 * bobby + 1.11 * laura >= 35)
m.addConstr(0.67 * hank + 2.09 * george >= 47)
m.addConstr(4.63 * bobby + 2.09 * george >= 67)
m.addConstr(0.67 * hank + 4.63 * bobby + 1.11 * laura >= 38)
m.addConstr(0.67 * hank + 2.09 * george + 1.11 * laura >= 38)
m.addConstr(0.67 * hank + 4.63 * bobby + 1.11 * laura >= 35)
m.addConstr(0.67 * hank + 2.09 * george + 1.11 * laura >= 35)
m.addConstr(0.67 * hank + 4.63 * bobby + 2.09 * george + 1.11 * laura >= 35)
m.addConstr(0.46 * george + 3.84 * laura >= 29)
m.addConstr(2.24 * bobby + 0.46 * george >= 30)
m.addConstr(4.2 * hank + 3.84 * laura >= 54)
m.addConstr(4.2 * hank + 2.24 * bobby >= 44)
m.addConstr(4.2 * hank + 2.24 * bobby + 0.46 * george + 3.84 * laura >= 44)
m.addConstr(-3 * george + 5 * laura >= 0)
m.addConstr(2.8 * hank + 3.72 * bobby <= 170)
m.addConstr(2.72 * george + 0.01 * laura <= 134)
m.addConstr(2.8 * hank + 3.72 * bobby + 0.01 * laura <= 260)
m.addConstr(3.72 * bobby + 2.72 * george + 0.01 * laura <= 265)
m.addConstr(2.8 * hank + 3.72 * bobby + 2.72 * george <= 77)
m.addConstr(1.37 * hank + 5.56 * bobby + 4.96 * george <= 138)
m.addConstr(5.56 * bobby + 4.96 * george + 4.27 * laura <= 156)
m.addConstr(4.63 * bobby + 2.09 * george <= 171)
m.addConstr(0.67 * hank + 1.11 * laura <= 123)
m.addConstr(4.2 * hank + 3.84 * laura <= 226)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

