
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables - assuming non-negativity for hours worked
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")  # Integer constraint for Hank
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")  # Continuous for Bobby
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")  # Integer constraint for George
x3 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Laura")  # Integer constraint for Laura

# Objective function: Minimize costs
m.setObjective(6.92*x0 + 4.83*x1 + 4.38*x2 + 2.46*x3, GRB.MINIMIZE)

# Constraints - examples (not exhaustive due to the extensive list)
# Dollar cost constraints
m.addConstr(2.8*x0 + 3.72*x1 >= 170, name="dollar_cost_Hank_Bobby")
m.addConstr(2.8*x0 + 2.72*x2 >= 74, name="dollar_cost_Hank_George")
# ... add other constraints similarly ...

# Mixed integer and linear constraints
m.addConstr(-3*x2 + 5*x3 >= 0, name="mixed_integer_constraint")

# Solve the model
m.optimize()

# Check if an optimal solution was found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found.")

