
import gurobipy as gp

# Create a new model
model = gp.Model("diet_problem")

# Create variables
ramen = model.addVar(lb=0, name="ramen")
cheeseburgers = model.addVar(lb=0, name="cheeseburgers")


# Set objective function
model.setObjective(1 * ramen + 2 * cheeseburgers, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(20 * ramen + 9 * cheeseburgers >= 16, "iron_min")
model.addConstr(11 * ramen + 19 * cheeseburgers >= 45, "calcium_min")
model.addConstr(-2 * ramen + cheeseburgers >= 0, "ramen_cheeseburger_ratio")
model.addConstr(20 * ramen + 9 * cheeseburgers <= 64, "iron_max")
model.addConstr(11 * ramen + 19 * cheeseburgers <= 97, "calcium_max")



# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    print(f"  Bowls of Instant Ramen: {ramen.x}")
    print(f"  Cheeseburgers: {cheeseburgers.x}")
    print(f"  Objective value: {model.objVal}")

