
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_instant_ramen")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")

# Set the objective function
m.setObjective(1*x0 + 2*x1, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(20*x0 + 9*x1 >= 16, "Iron_Constraint")
m.addConstr(11*x0 + 19*x1 >= 45, "Calcium_Constraint")
m.addConstr(-2*x0 + x1 >= 0, "Expression_Constraint")
m.addConstr(20*x0 + 9*x1 <= 64, "Iron_Upper_Bound")
m.addConstr(11*x0 + 19*x1 <= 97, "Calcium_Upper_Bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"bowls_of_instant_ramen: {x0.x}")
    print(f"cheeseburgers: {x1.x}")
else:
    print("No optimal solution found")
