
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="bowls_of_instant_ramen", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="cheeseburgers", lb=0)  # No lower bound specified, assuming 0

    # Objective function: Minimize 1*x1 + 2*x2
    model.setObjective(x1 + 2*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20*x1 + 9*x2 >= 16, name="iron_requirement")
    model.addConstr(11*x1 + 19*x2 >= 45, name="calcium_requirement")
    model.addConstr(-2*x1 + x2 >= 0, name="ramen_cheeseburger_relationship")
    model.addConstr(20*x1 + 9*x2 <= 74, name="iron_upper_bound")
    model.addConstr(11*x1 + 19*x2 <= 104, name="calcium_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"bowls of instant ramen: {x1.varValue}")
        print(f"cheeseburgers: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
