
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
apples = m.addVar(vtype=gp.GRB.INTEGER, name="apples")
rotisserie_chickens = m.addVar(vtype=gp.GRB.INTEGER, name="rotisserie_chickens")
protein_bars = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein_bars")


# Set objective function
m.setObjective(6 * apples + 6 * rotisserie_chickens + 8 * protein_bars, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * rotisserie_chickens + 8 * protein_bars >= 15)
m.addConstr(2 * apples + 8 * rotisserie_chickens >= 24)
m.addConstr(8 * rotisserie_chickens + 5 * protein_bars >= 23)
m.addConstr(2 * apples + 2 * protein_bars >= 26)
m.addConstr(2 * apples + 4 * rotisserie_chickens + 2 * protein_bars >= 28)
m.addConstr(2 * apples + 1 * protein_bars >= 8)
m.addConstr(6 * rotisserie_chickens + 8 * protein_bars <= 20)
m.addConstr(6 * apples + 5 * rotisserie_chickens <= 51)
m.addConstr(6 * apples + 5 * rotisserie_chickens + 8 * protein_bars <= 51)
m.addConstr(2 * apples + 5 * protein_bars <= 56)
m.addConstr(2 * apples + 8 * rotisserie_chickens + 5 * protein_bars <= 56)
m.addConstr(3 * rotisserie_chickens + 4 * protein_bars <= 43)
m.addConstr(7 * apples + 3 * rotisserie_chickens <= 88)
m.addConstr(7 * apples + 3 * rotisserie_chickens + 4 * protein_bars <= 88)
m.addConstr(2 * apples + 4 * rotisserie_chickens <= 47)
m.addConstr(2 * apples + 4 * rotisserie_chickens + 2 * protein_bars <= 47)
m.addConstr(5 * rotisserie_chickens + 1 * protein_bars <= 44)
m.addConstr(2 * apples + 1 * protein_bars <= 51)
m.addConstr(2 * apples + 5 * rotisserie_chickens <= 25)
m.addConstr(2 * apples + 5 * rotisserie_chickens + 1 * protein_bars <= 25)

m.addConstr(6 * apples + 5 * rotisserie_chickens + 8 * protein_bars <= 52) # Tastiness
m.addConstr(2 * apples + 8 * rotisserie_chickens + 5 * protein_bars <= 90) # Protein
m.addConstr(7 * apples + 3 * rotisserie_chickens + 4 * protein_bars <= 95) # Healthiness
m.addConstr(2 * apples + 4 * rotisserie_chickens + 2 * protein_bars <= 86) # Cost
m.addConstr(2 * apples + 5 * rotisserie_chickens + 1 * protein_bars <= 68) # Carbs


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('apples:', apples.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
    print('protein_bars:', protein_bars.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

