
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="apples", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="protein_bars")

    # Define the objective function
    model.setObjective(6 * x0 + 6 * x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * x1 + 8 * x2 >= 15)
    model.addConstr(2 * x0 + 8 * x1 >= 24)
    model.addConstr(8 * x1 + 5 * x2 >= 23)
    model.addConstr(2 * x0 + 2 * x2 >= 26)
    model.addConstr(2 * x0 + 4 * x1 + 2 * x2 >= 28)
    model.addConstr(2 * x0 + x2 >= 8)
    model.addConstr(5 * x1 + 8 * x2 <= 20)
    model.addConstr(6 * x0 + 5 * x1 <= 51)
    model.addConstr(6 * x0 + 5 * x1 + 8 * x2 <= 51)
    model.addConstr(2 * x0 + 5 * x2 <= 56)
    model.addConstr(2 * x0 + 8 * x1 + 5 * x2 <= 56)
    model.addConstr(3 * x1 + 4 * x2 <= 43)
    model.addConstr(7 * x0 + 3 * x1 <= 88)
    model.addConstr(7 * x0 + 3 * x1 + 4 * x2 <= 88)
    model.addConstr(2 * x0 + 4 * x1 <= 47)
    model.addConstr(2 * x0 + 4 * x1 + 2 * x2 <= 47)
    model.addConstr(5 * x1 + x2 <= 44)
    model.addConstr(2 * x0 + x2 <= 51)
    model.addConstr(2 * x0 + 5 * x1 <= 25)
    model.addConstr(2 * x0 + 5 * x1 + x2 <= 25)

    # Set bounds for variables
    x0.lb = 0
    x1.lb = 0
    x2.lb = 0

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Apples: ", x0.varValue)
        print("Rotisserie Chickens: ", x1.varValue)
        print("Protein Bars: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
