
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")
mary = m.addVar(vtype=gp.GRB.CONTINUOUS, name="mary")
george = m.addVar(vtype=gp.GRB.CONTINUOUS, name="george")
peggy = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy")
hank = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hank")


# Set objective function
m.setObjective(4 * ringo + 6 * mary + 4 * george + 3 * peggy + 1 * hank, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * george + 3 * hank >= 8)
m.addConstr(1 * ringo + 2 * peggy >= 5)
m.addConstr(4 * mary + 2 * hank >= 6)
m.addConstr(1 * ringo + 2 * george >= 11)
m.addConstr(1 * ringo + 5 * peggy >= 5)
m.addConstr(2 * george + 5 * peggy + 2 * hank >= 11)
m.addConstr(3 * george + 2 * peggy <= 82)
m.addConstr(5 * ringo + 3 * george <= 31)
m.addConstr(4 * mary + 2 * peggy <= 61)
m.addConstr(5 * ringo + 2 * peggy <= 41)
m.addConstr(5 * ringo + 4 * mary <= 100)
m.addConstr(5 * ringo + 3 * hank <= 52)
m.addConstr(4 * mary + 3 * george <= 66)
m.addConstr(4 * mary + 3 * george + 2 * peggy <= 41)
m.addConstr(5 * ringo + 4 * mary + 2 * peggy <= 34)
m.addConstr(5 * ringo + 4 * mary + 3 * george + 2 * peggy + 3 * hank <= 34)
m.addConstr(2 * george + 2 * hank <= 39)
m.addConstr(1 * ringo + 4 * mary <= 45)
m.addConstr(4 * mary + 2 * hank <= 43)
m.addConstr(2 * peggy + 2 * hank <= 31)
m.addConstr(1 * ringo + 4 * mary + 2 * hank <= 45)
m.addConstr(1 * ringo + 4 * mary + 2 * george + 2 * peggy + 2 * hank <= 45)
m.addConstr(5 * mary + 2 * george <= 40)
m.addConstr(5 * mary + 2 * hank <= 44)
m.addConstr(1 * ringo + 5 * mary <= 34)
m.addConstr(1 * ringo + 5 * mary + 2 * george + 5 * peggy + 2 * hank <= 34)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

