
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='x0', lb=0, integrality=1) # hours worked by Ringo
x1 = model.addVar(name='x1', lb=0) # hours worked by Mary
x2 = model.addVar(name='x2', lb=0) # hours worked by George
x3 = model.addVar(name='x3', lb=0) # hours worked by Peggy
x4 = model.addVar(name='x4', lb=0) # hours worked by Hank

# Define the objective function
model.setObjective(4*x0 + 6*x1 + 4*x2 + 3*x3 + 1*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x2 + 3*x4 >= 8)
model.addConstr(1*x0 + 2*x3 >= 5)
model.addConstr(4*x1 + 2*x4 >= 6)
model.addConstr(1*x0 + 2*x2 >= 11)
model.addConstr(1*x0 + 5*x3 >= 5)
model.addConstr(2*x2 + 5*x3 + 2*x4 >= 11)
model.addConstr(3*x2 + 2*x3 <= 82)
model.addConstr(5*x0 + 3*x2 <= 31)
model.addConstr(4*x1 + 2*x3 <= 61)
model.addConstr(5*x0 + 2*x3 <= 41)
model.addConstr(5*x0 + 4*x1 <= 100)
model.addConstr(5*x0 + 3*x4 <= 52)
model.addConstr(4*x1 + 3*x2 <= 66)
model.addConstr(4*x1 + 3*x2 + 2*x3 <= 41)
model.addConstr(5*x0 + 4*x1 + 2*x3 <= 34)
model.addConstr(5*x0 + 4*x1 + 3*x2 + 2*x3 + 3*x4 <= 34)
model.addConstr(2*x2 + 2*x4 <= 39)
model.addConstr(1*x0 + 4*x1 <= 45)
model.addConstr(4*x1 + 2*x4 <= 43)
model.addConstr(2*x3 + 2*x4 <= 31)
model.addConstr(1*x0 + 4*x1 + 2*x4 <= 45)
model.addConstr(1*x0 + 4*x1 + 2*x2 + 2*x3 + 2*x4 <= 45)
model.addConstr(5*x1 + 2*x2 <= 40)
model.addConstr(5*x1 + 2*x4 <= 44)
model.addConstr(1*x0 + 5*x1 <= 34)
model.addConstr(1*x0 + 5*x1 + 2*x2 + 5*x3 + 2*x4 <= 34)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
else:
    print('No solution found')
