
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    model.setObjective(8*x0 + 8*x1 + 4*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(10*x0 + 2*x2 >= 19, "c0")
    model.addConstr(10*x0 + 3*x1 >= 7, "c1")
    model.addConstr(10*x0 + 3*x1 + 2*x2 >= 7, "c2")
    model.addConstr(7*x1 + 11*x2 >= 20, "c3")
    model.addConstr(5*x0 + 11*x2 >= 21, "c4")
    model.addConstr(5*x0 + 7*x1 + 11*x2 >= 21, "c5")
    model.addConstr(-3*x0 + 9*x1 >= 0, "c6")
    model.addConstr(3*x1 + 2*x2 <= 61, "c7")

    # Resource Constraints
    model.addConstr(10*x0 <= 66, "c8")
    model.addConstr(5*x0 <= 73, "c9")
    model.addConstr(3*x1 <= 66, "c10")
    model.addConstr(7*x1 <= 73, "c11")
    model.addConstr(2*x2 <= 66, "c12")
    model.addConstr(11*x2 <= 73, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
