
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bobby", lb=0)
x1 = m.addVar(name="hours_worked_by_Laura", lb=0)
x2 = m.addVar(name="hours_worked_by_Bill", lb=0)

# Objective function
m.setObjective(8*x0 + 8*x1 + 4*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(10*x0 == 10, name="Bobby_organization_score")
m.addConstr(5*x0 == 5, name="Bobby_work_quality_rating")
m.addConstr(3*x1 == 3, name="Laura_organization_score")
m.addConstr(7*x1 == 7, name="Laura_work_quality_rating")
m.addConstr(2*x2 == 2, name="Bill_organization_score")
m.addConstr(11*x2 == 11, name="Bill_work_quality_rating")
m.addConstr(10*x0 + 2*x2 >= 19, name="combined_organization_score_Bobby_Bill")
m.addConstr(10*x0 + 3*x1 >= 7, name="combined_organization_score_Bobby_Laura")
m.addConstr(10*x0 + 3*x1 + 2*x2 >= 7, name="combined_organization_score_all")
m.addConstr(7*x1 + 11*x2 >= 20, name="combined_work_quality_rating_Laura_Bill")
m.addConstr(5*x0 + 11*x2 >= 21, name="combined_work_quality_rating_Bobby_Bill")
m.addConstr(5*x0 + 7*x1 + 11*x2 >= 21, name="combined_work_quality_rating_all")
m.addConstr(-3*x0 + 9*x1 >= 0, name="Bobby_Laura_constraint")
m.addConstr(3*x1 + 2*x2 <= 61, name="Laura_Bill_organization_score")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bobby: ", x0.varValue)
    print("Hours worked by Laura: ", x1.varValue)
    print("Hours worked by Bill: ", x2.varValue)
else:
    print("The model is infeasible")
