
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies") # blueberry pies
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="rotisserie_chickens") # rotisserie chickens
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="steaks") # steaks


# Set objective function
m.setObjective(4*x0 + 6*x1 + 6*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(19*x0 + 4*x1 + 32*x2 >= 72, "min_cost")
m.addConstr(20*x0 + 24*x1 + 34*x2 >= 52, "min_protein")
m.addConstr(19*x0 + 32*x2 <= 151, "max_pies_steaks_cost")
m.addConstr(19*x0 + 4*x1 <= 162, "max_pies_chickens_cost")
m.addConstr(4*x1 + 32*x2 <= 190, "max_chickens_steaks_cost")
m.addConstr(19*x0 + 4*x1 + 32*x2 <= 196, "max_total_cost")
m.addConstr(24*x1 + 34*x2 <= 61, "max_chickens_steaks_protein")
m.addConstr(20*x0 + 24*x1 <= 78, "max_pies_chickens_protein")
m.addConstr(20*x0 + 24*x1 + 34*x2 <= 162, "max_total_protein")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

