
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="blueberry_pies", lb=0, ub=None, type=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(name="rotisserie_chickens", lb=0, ub=None, type=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="steaks", lb=0, ub=None, type=gurobi.GRB.INTEGER)

    # Define objective function
    model.setObjective(4 * x0 + 6 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(19 * x0 + 4 * x1 + 32 * x2 >= 72)
    model.addConstr(20 * x0 + 24 * x1 + 34 * x2 >= 52)
    model.addConstr(19 * x0 + 32 * x2 <= 151)
    model.addConstr(19 * x0 + 4 * x1 <= 162)
    model.addConstr(4 * x1 + 32 * x2 <= 190)
    model.addConstr(19 * x0 + 4 * x1 + 32 * x2 <= 196)
    model.addConstr(24 * x1 + 34 * x2 <= 61)
    model.addConstr(20 * x0 + 24 * x1 <= 78)
    model.addConstr(20 * x0 + 24 * x1 + 34 * x2 <= 162)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Blueberry pies: {x0.varValue}")
        print(f"Rotisserie chickens: {x1.varValue}")
        print(f"Steaks: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
