
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B5
    x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="x1") # milligrams of vitamin B6

    # Set objective function
    model.setObjective(1.35*x0**2 + 9.21*x0*x1 + 6.81*x1**2, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*x0 + 8*x1 >= 34, "c0")
    model.addConstr(4*x0**2 + 8*x1**2 >= 41, "c1")
    model.addConstr(-6*x0**2 + 3*x1**2 >= 0, "c2")
    model.addConstr(2*x0**2 + 8*x1**2 <= 84, "c3")
    model.addConstr(2*x0 + 8*x1 <= 84, "c4")
    model.addConstr(4*x0 + 8*x1 <= 57, "c5")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"x0 (milligrams of vitamin B5): {x0.x}")
        print(f"x1 (milligrams of vitamin B6): {x1.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
