
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B5
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B6

    # Objective function
    model.setObjective(1.35*x1**2 + 9.21*x1*x2 + 6.81*x2**2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 8*x2 >= 34, name="cardiovascular_support_min")
    model.addConstr(16*x1**2 + 64*x2**2 >= 41, name="cognitive_performance_min")
    model.addConstr(-6*x1**2 + 3*x2**2 >= 0, name="vitamin_interaction")
    model.addConstr(4*x1**2 + 64*x2**2 <= 84, name="cardiovascular_support_max_quad")
    model.addConstr(2*x1 + 8*x2 <= 84, name="cardiovascular_support_max_lin")
    model.addConstr(4*x1 + 8*x2 <= 57, name="cognitive_performance_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
