
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="Mbps bandwidth allocated to monitoring")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="intrusion analysts")


    # Set objective function
    model.setObjective(2*x0**2 + 3*x0*x1 + 2*x1**2 + 2*x0 + 7*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(19*x0 <= 93, "c0")
    model.addConstr(19*x0 <= 90, "c1")
    model.addConstr(13*x0 <= 268, "c2")
    model.addConstr(22*x0 <= 149, "c3")
    model.addConstr(21*x1 <= 93, "c4")
    model.addConstr(9*x1 <= 90, "c5")
    model.addConstr(13*x1 <= 268, "c6")
    model.addConstr(6*x1 <= 149, "c7")
    model.addConstr(19*x0 + 21*x1 >= 33, "c8")
    model.addConstr(19*x0 + 9*x1 >= 31, "c9")
    model.addConstr(13*x0 + 13*x1 >= 90, "c10")
    model.addConstr(22*x0 + 6*x1 >= 62, "c11")
    model.addConstr(10*x0 - 6*x1 >= 0, "c12")
    model.addConstr(19*x0 + 21*x1 <= 90, "c13")
    model.addConstr(19*x0**2 + 9*x1**2 <= 57, "c14")
    model.addConstr(22*x0 + 6*x1 <= 114, "c15")



    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
