
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="Mbps_bandwidth_allocated_to_monitoring", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(2*x1**2 + 3*x1*x2 + 2*x2**2 + 2*x1 + 7*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(19*x1 <= 93)
m.addConstr(19*x1 <= 90)
m.addConstr(13*x1 <= 268)
m.addConstr(22*x1 <= 149)
m.addConstr(21*x2 <= 93)
m.addConstr(9*x2 <= 90)
m.addConstr(13*x2 <= 268)
m.addConstr(6*x2 <= 149)
m.addConstr(19*x1 + 21*x2 >= 33)
m.addConstr(19*x1 + 9*x2 >= 31)
m.addConstr(13*x1 + 13*x2 >= 90)
m.addConstr(22*x1 + 6*x2 >= 62)
m.addConstr(10*x1 - 6*x2 >= 0)
m.addConstr(19*x1 + 21*x2 <= 90)
m.addConstr((19*x1)**2 + (9*x2)**2 <= 57)
m.addConstr(22*x1 + 6*x2 <= 114)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Mbps bandwidth allocated to monitoring:", x1.varValue)
    print("intrusion analysts:", x2.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
