
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin K
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B6


    # Set objective function
    model.setObjective(1*x0 + 9*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*x0 + 7*x1 >= 11, "c0")
    model.addConstr(3*x0 + 9*x1 >= 31, "c1")
    model.addConstr(10*x0 + 5*x1 >= 12, "c2")
    model.addConstr(4*x0 + 10*x1 >= 13, "c3")
    model.addConstr(10*x0 + 7*x1 >= 9, "c4")
    model.addConstr(-7*x0 + x1 >= 0, "c5")
    model.addConstr(2*x0 + 7*x1 <= 23, "c6")
    model.addConstr(3*x0 + 9*x1 <= 41, "c7")
    model.addConstr(10*x0 + 5*x1 <= 47, "c8")
    model.addConstr(4*x0 + 10*x1 <= 68, "c9")
    model.addConstr(10*x0 + 7*x1 <= 25, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
