
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_K", lb=0)  # Non-negative
    x2 = model.addVar(name="milligrams_of_vitamin_B6", lb=0)  # Non-negative

    # Define the objective function
    model.setObjective(x1 + 9 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * x1 >= 2)
    model.addConstr(3 * x1 >= 3)
    model.addConstr(10 * x1 >= 10)
    model.addConstr(4 * x1 >= 4)
    model.addConstr(10 * x1 >= 10)

    model.addConstr(7 * x2 >= 7)
    model.addConstr(9 * x2 >= 9)
    model.addConstr(5 * x2 >= 5)
    model.addConstr(10 * x2 >= 10)
    model.addConstr(7 * x2 >= 7)

    model.addConstr(2 * x1 + 7 * x2 >= 11)
    model.addConstr(3 * x1 + 9 * x2 >= 31)
    model.addConstr(10 * x1 + 5 * x2 >= 12)
    model.addConstr(4 * x1 + 10 * x2 >= 13)
    model.addConstr(10 * x1 + 7 * x2 >= 9)

    model.addConstr(-7 * x1 + x2 >= 0)

    model.addConstr(2 * x1 + 7 * x2 <= 23)
    model.addConstr(3 * x1 + 9 * x2 <= 41)
    model.addConstr(10 * x1 + 5 * x2 <= 47)
    model.addConstr(4 * x1 + 10 * x2 <= 68)
    model.addConstr(10 * x1 + 7 * x2 <= 25)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin K: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
