
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_a = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_a")
vitamin_b5 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b5")
carbohydrates = m.addVar(vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
vitamin_e = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_b4 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")


# Set objective function
m.setObjective(5.59 * vitamin_a + 5.49 * vitamin_b5 + 3.39 * carbohydrates + 1.19 * vitamin_e + 8.96 * vitamin_b4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * vitamin_a + vitamin_b5 >= 18)
m.addConstr(8 * vitamin_a + 4 * carbohydrates >= 11)
m.addConstr(4 * carbohydrates + 5 * vitamin_e >= 19)
m.addConstr(vitamin_b5 + 4 * carbohydrates + 5 * vitamin_b4 >= 12)
m.addConstr(8 * vitamin_a + vitamin_b5 + 4 * carbohydrates + 5 * vitamin_e + 5 * vitamin_b4 >= 12)
m.addConstr(2 * vitamin_b5 + 6 * vitamin_e >= 15)
m.addConstr(2 * vitamin_b5 + 3 * vitamin_b4 >= 11)
m.addConstr(7 * carbohydrates + 3 * vitamin_b4 >= 22)
m.addConstr(4 * vitamin_a + 3 * vitamin_b4 >= 22)
m.addConstr(4 * vitamin_a + 6 * vitamin_e >= 19)
m.addConstr(4 * vitamin_a + 2 * vitamin_b5 >= 21)
# ... (rest of the constraints from the JSON, adapted similarly)

m.addConstr(8 * vitamin_a + vitamin_b5 + 4 * carbohydrates + 5 * vitamin_e + 5 * vitamin_b4 <= 102)
m.addConstr(4 * vitamin_a + 2 * vitamin_b5 + 7 * carbohydrates + 6 * vitamin_e + 3 * vitamin_b4 <= 112)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

