
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin A
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B5
    x3 = model.addVar(name="x3")  # grams of carbohydrates
    x4 = model.addVar(name="x4")  # milligrams of vitamin E
    x5 = model.addVar(name="x5")  # milligrams of vitamin B4

    # Define the objective function
    model.setObjective(5.59 * x1 + 5.49 * x2 + 3.39 * x3 + 1.19 * x4 + 8.96 * x5, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8 * x1 <= 102)
    model.addConstr(4 * x1 <= 112)
    model.addConstr(1 * x2 <= 102)
    model.addConstr(2 * x2 <= 112)
    model.addConstr(4 * x3 <= 102)
    model.addConstr(7 * x3 <= 112)
    model.addConstr(5 * x4 <= 102)
    model.addConstr(6 * x4 <= 112)
    model.addConstr(5 * x5 <= 102)
    model.addConstr(3 * x5 <= 112)
    model.addConstr(8 * x1 + 1 * x2 >= 18)
    model.addConstr(8 * x1 + 4 * x3 >= 11)
    model.addConstr(4 * x3 + 5 * x4 >= 19)
    model.addConstr(1 * x2 + 4 * x3 + 5 * x5 >= 12)
    model.addConstr(8 * x1 + 1 * x2 + 4 * x3 + 5 * x4 + 5 * x5 >= 12)
    model.addConstr(2 * x2 + 6 * x4 >= 15)
    model.addConstr(2 * x2 + 3 * x5 >= 11)
    model.addConstr(7 * x3 + 3 * x5 >= 22)
    model.addConstr(4 * x1 + 3 * x5 >= 22)
    model.addConstr(4 * x1 + 6 * x4 >= 19)
    model.addConstr(4 * x1 + 2 * x2 >= 21)
    model.addConstr(2 * x2 + 7 * x3 + 6 * x4 >= 11)
    model.addConstr(7 * x3 + 6 * x4 + 3 * x5 >= 11)
    model.addConstr(4 * x1 + 6 * x4 + 3 * x5 >= 11)
    model.addConstr(4 * x1 + 2 * x2 + 7 * x3 >= 11)
    model.addConstr(2 * x2 + 7 * x3 + 6 * x4 >= 19)
    model.addConstr(7 * x3 + 6 * x4 + 3 * x5 >= 19)
    model.addConstr(4 * x1 + 6 * x4 + 3 * x5 >= 19)
    model.addConstr(4 * x1 + 2 * x2 + 7 * x3 >= 19)
    model.addConstr(2 * x2 + 7 * x3 + 6 * x4 >= 18)
    model.addConstr(7 * x3 + 6 * x4 + 3 * x5 >= 18)
    model.addConstr(4 * x1 + 6 * x4 + 3 * x5 >= 18)
    model.addConstr(4 * x1 + 2 * x2 + 7 * x3 >= 18)
    model.addConstr(4 * x1 + 2 * x2 + 7 * x3 + 6 * x4 + 3 * x5 >= 18)
    model.addConstr(2 * x3 - 4 * x5 >= 0)
    model.addConstr(8 * x1 + 4 * x3 <= 73)
    model.addConstr(4 * x3 + 5 * x5 <= 89)
    model.addConstr(1 * x2 + 4 * x3 <= 44)
    model.addConstr(8 * x1 + 1 * x2 <= 76)
    model.addConstr(1 * x2 + 5 * x5 <= 31)
    model.addConstr(1 * x2 + 4 * x3 + 5 * x4 <= 52)
    model.addConstr(2 * x2 + 3 * x5 <= 65)
    model.addConstr(4 * x1 + 2 * x2 <= 28)
    model.addConstr(7 * x3 + 6 * x4 <= 95)
    model.addConstr(2 * x2 + 6 * x4 <= 92)
    model.addConstr(2 * x2 + 7 * x3 <= 36)
    model.addConstr(4 * x1 + 3 * x5 <= 39)
    model.addConstr(4 * x1 + 6 * x4 <= 94)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"x4: {x4.varValue}")
        print(f"x5: {x5.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
