
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    cucumber_vines = m.addVar(vtype=gp.GRB.INTEGER, name="cucumber_vines")
    coleus = m.addVar(vtype=gp.GRB.INTEGER, name="coleus")
    tulips = m.addVar(vtype=gp.GRB.INTEGER, name="tulips")
    tomato_vines = m.addVar(vtype=gp.GRB.INTEGER, name="tomato_vines")

    # Set objective function
    m.setObjective(5*cucumber_vines*coleus + 3*cucumber_vines*tomato_vines + 5*coleus*tomato_vines + tulips**2 + 4*tulips*tomato_vines + 2*tomato_vines**2 + 7*cucumber_vines + coleus + 6*tulips, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9.65*coleus + 5.01*tulips >= 57)
    m.addConstr(9.65*cucumber_vines + 11.51*tomato_vines >= 59)
    m.addConstr((5.01*tulips)**2 + (11.51*tomato_vines)**2 >= 24)
    m.addConstr((9.65*cucumber_vines)**2 + (15.49*coleus)**2 + (11.51*tomato_vines)**2 >= 66)
    m.addConstr((9.65*cucumber_vines)**2 + (5.01*tulips)**2 + (11.51*tomato_vines)**2 >= 66)
    m.addConstr(9.65*cucumber_vines + 15.49*coleus + 11.51*tomato_vines >= 65)
    m.addConstr(9.65*cucumber_vines + 5.01*tulips + 11.51*tomato_vines >= 65)
    m.addConstr(16.96*coleus + 12.34*tomato_vines >= 32)
    m.addConstr((16.96*coleus)**2 + (11.65*tulips)**2 >= 67)
    m.addConstr(11.65*tulips + 12.34*tomato_vines >= 33)
    m.addConstr(5.29*cucumber_vines + 12.34*tomato_vines >= 67)
    m.addConstr(-10*cucumber_vines + 2*coleus >= 0)
    m.addConstr((9.65*cucumber_vines)**2 + (5.01*tulips)**2 <= 184)
    m.addConstr(15.49*coleus + 5.01*tulips <= 217)
    m.addConstr((9.65*cucumber_vines)**2 + (11.51*tomato_vines)**2 <= 154)
    m.addConstr(9.65*cucumber_vines + 15.49*coleus + 5.01*tulips <= 160)
    m.addConstr(9.65*cucumber_vines + 15.49*coleus + 5.01*tulips + 11.51*tomato_vines <= 160)
    m.addConstr((16.96*coleus)**2 + (11.65*tulips)**2 <= 175)
    m.addConstr(5.29*cucumber_vines + 16.96*coleus + 11.65*tulips + 12.34*tomato_vines <= 175)
    m.addConstr(9.65*cucumber_vines + 15.49*coleus + 5.01*tulips + 11.51*tomato_vines <= 283)
    m.addConstr(5.29*cucumber_vines + 16.96*coleus + 11.65*tulips + 12.34*tomato_vines <= 281)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
