
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bananas = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
black_beans = m.addVar(lb=0, vtype=GRB.INTEGER, name="black_beans")


# Set objective function
m.setObjective(5.82*bananas**2 + 3.1*bananas*black_beans + 2.57*black_beans**2 + 2.55*bananas + 9.79*black_beans, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*bananas + 17*black_beans >= 54, "calcium_min")
m.addConstr(8*bananas - 7*black_beans >= 0, "banana_black_bean_ratio")
m.addConstr(12*bananas + 17*black_beans <= 91, "calcium_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Bananas: {bananas.x}")
    print(f"Black Beans: {black_beans.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

