
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")
x2 = m.addVar(vtype=GRB.INTEGER, name="black_beans")

# Set the objective function
m.setObjective(5.82*x1**2 + 3.1*x1*x2 + 2.57*x2**2 + 2.55*x1 + 9.79*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 17*x2 >= 54, name="calcium_minimum")
m.addConstr(8*x1 - 7*x2 >= 0, name="bananas_blackbeans_ratio")
m.addConstr(12*x1 + 17*x2 <= 128, name="calcium_maximum")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bananas: {x1.x}")
    print(f"Black Beans: {x2.x}")
else:
    print("No optimal solution found")
