
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    bananas = model.addVar(name="bananas", lb=0, ub=None)
    black_beans = model.addVar(name="black beans", lb=0, integer=True)

    # Objective function
    model.setObjective(5.82 * bananas**2 + 3.1 * bananas * black_beans + 2.57 * black_beans**2 + 2.55 * bananas + 9.79 * black_beans, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12 * bananas + 17 * black_beans >= 54, name="calcium_lower_bound")
    model.addConstr(8 * bananas - 7 * black_beans >= 0, name="bananas_vs_black_beans")
    model.addConstr(12 * bananas + 17 * black_beans <= 91, name="calcium_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bananas: {bananas.varValue}")
        print(f"Black Beans: {black_beans.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
