
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours_worked_by_Paul")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")


# Set objective function
m.setObjective(1.38 * x0 + 7.91 * x1 + 2.21 * x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * x0 + 11 * x2 >= 42, "c0")
m.addConstr(1 * x0 + 8 * x1 >= 14, "c1")
m.addConstr(1 * x0 + 8 * x1 + 11 * x2 >= 25, "c2")
m.addConstr(-5 * x0 + 5 * x2 >= 0, "c3")
m.addConstr(8 * x1 + 11 * x2 <= 80, "c4")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0:', x0.x)
    print('x1:', x1.x)
    print('x2:', x2.x)

elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

