
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Mary")
x1 = m.addVar(vtype=GRB.INTEGER, lb=0, name="hours_worked_by_Paul")
x2 = m.addVar(lb=0, name="hours_worked_by_Bobby")

# Define the objective function
m.setObjective(1.38*x0 + 7.91*x1 + 2.21*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x0 + 11*x2 >= 42)
m.addConstr(1*x0 + 8*x1 >= 14)
m.addConstr(1*x0 + 8*x1 + 11*x2 >= 25)
m.addConstr(-5*x0 + 5*x2 >= 0)
m.addConstr(8*x1 + 11*x2 <= 80)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Mary: {x0.x}")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Bobby: {x2.x}")
else:
    print("No optimal solution found")
