
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Mary", lb=0)  # Mary can work fractional hours
x2 = m.addVar(name="hours_worked_by_Paul", lb=0, vtype=gurobi.GRB.INTEGER)  # Paul must work integer hours
x3 = m.addVar(name="hours_worked_by_Bobby", lb=0)  # Bobby can work fractional hours

# Objective function
m.setObjective(1.38*x1 + 7.91*x2 + 2.21*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x1 + 11*x3 >= 42, name="combined_Mary_Bobby_score")
m.addConstr(x1 + 8*x2 >= 14, name="combined_Mary_Paul_score")
m.addConstr(x1 + 8*x2 + 11*x3 >= 25, name="combined_score")
m.addConstr(-5*x1 + 5*x3 >= 0, name="Mary_Bobby_hours")
m.addConstr(8*x2 + 11*x3 <= 80, name="Paul_Bobby_score")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Mary: {x1.varValue}")
    print(f"Hours worked by Paul: {x2.varValue}")
    print(f"Hours worked by Bobby: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
