
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="grams_of_fiber")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_E")

    # Set objective function
    m.setObjective(3.18 * x0 + 3.26 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10 * x0 + 11 * x1 >= 13, "c0")
    m.addConstr(13 * x0 + 12 * x1 >= 18, "c1")
    m.addConstr(16 * x0 + 10 * x1 >= 16, "c2")
    m.addConstr(5 * x0 - 10 * x1 >= 0, "c3")
    m.addConstr(10 * x0 + 11 * x1 <= 61, "c4")
    m.addConstr(13 * x0 + 12 * x1 <= 50, "c5")
    m.addConstr(16 * x0 + 10 * x1 <= 46, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
