
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="grams_of_fiber")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_E")

# Objective function: maximize 3.18*x1 + 3.26*x2
m.setObjective(3.18 * x1 + 3.26 * x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 11*x2 >= 13, "cognitive_performance_index")
m.addConstr(13*x1 + 12*x2 >= 18, "cardiovascular_support_index")
m.addConstr(16*x1 + 10*x2 >= 16, "kidney_support_index")
m.addConstr(5*x1 - 10*x2 >= 0, "additional_constraint")
m.addConstr(10*x1 + 11*x2 <= 61, "cognitive_upper_bound")
m.addConstr(13*x1 + 12*x2 <= 50, "cardiovascular_upper_bound")
m.addConstr(16*x1 + 10*x2 <= 46, "kidney_upper_bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Fiber: {x1.x}")
    print(f"Milligrams of Vitamin E: {x2.x}")
else:
    print("No optimal solution found")
