
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="grams_of_fiber", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="milligrams_of_vitamin_E")
    
    # Objective function
    model.setObjective(3.18*x1 + 3.26*x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(10*x1 <= 62)
    model.addConstr(13*x1 <= 52)
    model.addConstr(16*x1 <= 82)
    model.addConstr(10*x1 + 11*x2 >= 13)
    model.addConstr(13*x1 + 12*x2 >= 18)
    model.addConstr(16*x1 + 10*x2 >= 16)
    model.addConstr(5*x1 - 10*x2 >= 0)
    model.addConstr(10*x1 + 11*x2 <= 61)
    model.addConstr(13*x1 + 12*x2 <= 50)
    model.addConstr(16*x1 + 10*x2 <= 46)
    model.addConstr(x1 <= 4)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Milligrams of vitamin E: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
