
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
steaks = m.addVar(vtype=GRB.INTEGER, name="steaks")
black_beans = m.addVar(vtype=GRB.INTEGER, name="black_beans")
cornichons = m.addVar(vtype=GRB.INTEGER, name="cornichons")
bagged_salads = m.addVar(vtype=GRB.INTEGER, name="bagged_salads")
granola_bars = m.addVar(vtype=GRB.INTEGER, name="granola_bars")
bananas = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")

# Set objective function
m.setObjective(4.25*steaks**2 + 8.49*steaks*black_beans + 2.19*steaks*cornichons + 3.14*steaks*bagged_salads + 4.62*steaks*granola_bars + 6.73*steaks*bananas + 4.87*black_beans**2 + 9.6*black_beans*cornichons + 9.83*black_beans*bagged_salads + 6.92*black_beans*bananas + 8.21*cornichons**2 + 5.75*cornichons*bagged_salads + 1.3*cornichons*granola_bars + 2.56*cornichons*bananas + 3.18*bagged_salads**2 + 9.78*bagged_salads*granola_bars + 2.82*bagged_salads*bananas + 7.23*granola_bars**2 + 5.33*granola_bars*bananas + 9.79*bananas**2 + 4.62*steaks + 3.18*black_beans + 9.92*cornichons + 5.75*bagged_salads + 2.71*granola_bars + 3.96*bananas, GRB.MINIMIZE)


# Add constraints
m.addConstr(4.12*black_beans + 0.39*granola_bars >= 18)
m.addConstr(6.58*cornichons + 0.39*granola_bars >= 8)
m.addConstr(0.39*granola_bars + 8.78*bananas >= 7)
m.addConstr(2.03*steaks + 4.12*black_beans >= 11)
m.addConstr(2.03*steaks + 6.58*cornichons + 0.39*granola_bars >= 14)
m.addConstr(2.03*steaks + 4.12*black_beans + 6.58*cornichons + 0.91*bagged_salads + 0.39*granola_bars + 8.78*bananas >= 14)
m.addConstr(4*cornichons - 8*bananas >= 0)
m.addConstr(2*black_beans**2 - granola_bars**2 >= 0)
m.addConstr(2*granola_bars - 9*bananas >= 0)
m.addConstr((2.03*steaks)**2 + (0.91*bagged_salads)**2 <= 123)
m.addConstr(2.03*steaks + 8.78*bananas <= 42)
m.addConstr((4.12*black_beans)**2 + (8.78*bananas)**2 <= 88)
m.addConstr((0.39*granola_bars)**2 + (8.78*bananas)**2 <= 49)
m.addConstr(0.91*bagged_salads + 8.78*bananas <= 98)
m.addConstr(6.58*cornichons + 8.78*bananas <= 95)
m.addConstr(6.58*cornichons + 0.91*bagged_salads <= 122)
m.addConstr((4.12*black_beans)**2 + (6.58*cornichons)**2 + (8.78*bananas)**2 <= 87)
m.addConstr(2.03*steaks + 0.39*granola_bars + 8.78*bananas <= 50)
m.addConstr(4.12*black_beans + 0.39*granola_bars + 8.78*bananas <= 42)
m.addConstr((2.03*steaks)**2 + (4.12*black_beans)**2 + (6.58*cornichons)**2 <= 30)
m.addConstr(4.12*black_beans + 0.91*bagged_salads + 0.39*granola_bars <= 83)
m.addConstr(4.12*black_beans + 6.58*cornichons + 0.39*granola_bars <= 72)
m.addConstr((2.03*steaks)**2 + (6.58*cornichons)**2 + (8.78*bananas)**2 <= 86)
m.addConstr(0.91*bagged_salads + 0.39*granola_bars + 8.78*bananas <= 106)
m.addConstr((2.03*steaks)**2 + (4.12*black_beans)**2 + (0.39*granola_bars)**2 <= 50)
m.addConstr(2.03*steaks + 6.58*cornichons + 0.91*bagged_salads <= 58)
m.addConstr((4.12*black_beans)**2 + (6.58*cornichons)**2 + (0.91*bagged_salads)**2 <= 96)
m.addConstr(2.03*steaks + 6.58*cornichons + 0.39*granola_bars <= 24)
m.addConstr((4.12*black_beans)**2 + (0.91*bagged_salads)**2 + (8.78*bananas)**2 <= 126)
m.addConstr((2.03*steaks)**2 + (4.12*black_beans)**2 + (8.78*bananas)**2 <= 108)
m.addConstr((2.03*steaks)**2 + (0.91*bagged_salads)**2 + (8.78*bananas)**2 <= 47)
m.addConstr(2.03*steaks + 4.12*black_beans + 6.58*cornichons + 0.91*bagged_salads + 0.39*granola_bars + 8.78*bananas <= 134)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
