
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Labor Cost")

# Create variables
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
mary = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mary")


# Set objective function
model.setObjective(5.23 * peggy + 3.46 * laura + 1.57 * bill + 4.21 * paul + 1.26 * mary, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(16 * paul + 4 * mary >= 20, "c0")
model.addConstr(12 * laura + 14 * bill >= 14, "c1")
model.addConstr(12 * laura + 4 * mary >= 10, "c2")
model.addConstr(16 * peggy + 12 * laura >= 18, "c3")
model.addConstr(16 * peggy + 4 * mary >= 8, "c4")
model.addConstr(16 * peggy + 9 * paul >= 12, "c5")
model.addConstr(16 * peggy + 14 * bill >= 21, "c6")
model.addConstr(12 * laura + 9 * paul >= 20, "c7")
model.addConstr(12 * laura + 9 * paul + 4 * mary >= 15, "c8")
model.addConstr(12 * laura + 14 * bill + 9 * paul >= 15, "c9")
model.addConstr(16 * peggy + 12 * laura + 9 * paul >= 15, "c10")
model.addConstr(12 * laura + 9 * paul + 4 * mary >= 15, "c11")

model.addConstr(16 * peggy + 12 * laura + 14 * bill + 9 * paul + 4 * mary >= 15, "c17")
model.addConstr(-paul + 10 * mary >= 0, "c18")
model.addConstr(-3 * peggy + 10 * paul >= 0, "c19")
model.addConstr(14 * bill + 9 * paul <= 81, "c20")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

