
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)  # Can be fractional
x2 = m.addVar(name="hours_worked_by_Laura", lb=0)  # Can be fractional
x3 = m.addVar(name="hours_worked_by_Bill", lb=0)  # Can be fractional
x4 = m.addVar(name="hours_worked_by_Paul", lb=0)  # Can be fractional
x5 = m.addVar(name="hours_worked_by_Mary", lb=0, type=gp.GRB.INTEGER)  # Must be integer

# Objective function
m.setObjective(5.23*x1 + 3.46*x2 + 1.57*x3 + 4.21*x4 + 1.26*x5, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(x1 >= 1)
m.addConstr(x2 >= 1)
m.addConstr(x3 >= 1)
m.addConstr(x4 >= 1)
m.addConstr(x5 >= 1)

m.addConstr(9*x4 + 4*x5 >= 20)
m.addConstr(12*x2 + 14*x3 >= 14)
m.addConstr(12*x2 + 4*x5 >= 10)
m.addConstr(16*x1 + 12*x2 >= 18)
m.addConstr(16*x1 + 4*x5 >= 8)
m.addConstr(16*x1 + 9*x4 >= 12)
m.addConstr(16*x1 + 14*x3 >= 21)
m.addConstr(12*x2 + 9*x4 >= 20)
m.addConstr(12*x2 + 9*x4 + 4*x5 >= 15)
m.addConstr(12*x2 + 14*x3 + 9*x4 >= 15)
m.addConstr(16*x1 + 12*x2 + 9*x4 >= 15)
m.addConstr(12*x2 + 9*x4 + 4*x5 >= 15)
m.addConstr(12*x2 + 14*x3 + 9*x4 >= 15)
m.addConstr(16*x1 + 12*x2 + 9*x4 >= 15)
m.addConstr(16*x1 + 12*x2 + 9*x4 + 4*x5 >= 15)
m.addConstr(-x4 + 10*x5 >= 0)
m.addConstr(-3*x1 + 10*x4 >= 0)
m.addConstr(14*x3 + 9*x4 <= 81)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Hours worked by Bill: ", x3.varValue)
    print("Hours worked by Paul: ", x4.varValue)
    print("Hours worked by Mary: ", x5.varValue)
else:
    print("The problem is infeasible")
