
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B12
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # milligrams of vitamin B2
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin D


    # Set objective function
    m.setObjective(1*x0 + 1*x1 + 3*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 4*x1 >= 30, "c1")
    m.addConstr(6*x0 + 5*x2 >= 19, "c2")
    m.addConstr(6*x0 + 4*x1 + 5*x2 >= 21, "c3")
    m.addConstr(10*x0 + 13*x1 >= 39, "c4")
    m.addConstr(13*x1 + 4*x2 >= 16, "c5")
    m.addConstr(10*x0 + 13*x1 + 4*x2 >= 23, "c6")
    m.addConstr(2*x0 - 7*x2 >= 0, "c7")
    m.addConstr(-7*x1 + 5*x2 >= 0, "c8")
    m.addConstr(-1*x0 + 7*x1 >= 0, "c9")
    m.addConstr(4*x1 + 5*x2 <= 78, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
