
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B12
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B2
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin D

    # Define the objective function
    model.setObjective(x0 + x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x0 + 4 * x1 >= 30)
    model.addConstr(6 * x0 + 5 * x2 >= 19)
    model.addConstr(6 * x0 + 4 * x1 + 5 * x2 >= 21)
    model.addConstr(13 * x1 + 4 * x2 >= 16)
    model.addConstr(10 * x0 + 13 * x1 >= 39)
    model.addConstr(10 * x0 + 13 * x1 + 4 * x2 >= 23)
    model.addConstr(2 * x0 - 7 * x2 >= 0)
    model.addConstr(-7 * x1 + 5 * x2 >= 0)
    model.addConstr(-x0 + 7 * x1 >= 0)
    model.addConstr(4 * x1 + 5 * x2 <= 78)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x0.varValue}")
        print(f"Milligrams of vitamin B2: {x1.varValue}")
        print(f"Milligrams of vitamin D: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
