
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")
jean = m.addVar(vtype=gp.GRB.CONTINUOUS, name="jean")
peggy = m.addVar(vtype=gp.GRB.INTEGER, name="peggy")

# Set objective function
m.setObjective(2.78*ringo**2 + 3.17*ringo*peggy + 1.44*jean**2 + 4.25*peggy**2 + 1.63*ringo + 9.56*peggy, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*ringo**2 + 10*jean**2 >= 23)
m.addConstr(10*jean + 6*peggy >= 16)
m.addConstr(3*ringo + 10*jean + 6*peggy >= 16)
m.addConstr(6*jean + 12*peggy >= 15)
m.addConstr(ringo + 12*peggy >= 27)
m.addConstr(ringo + 6*jean + 12*peggy >= 27)
m.addConstr(13*ringo**2 + 4*peggy**2 >= 21)
m.addConstr(13*ringo + 10*jean >= 10)
m.addConstr(13*ringo + 10*jean + 4*peggy >= 10)
m.addConstr(2*ringo - peggy >= 0)
m.addConstr(3*jean - 10*peggy >= 0)
m.addConstr(10*jean**2 + 6*peggy**2 <= 32)
m.addConstr(3*ringo**2 + 10*jean**2 + 6*peggy**2 <= 35)
m.addConstr(ringo + 6*jean <= 72)
m.addConstr(ringo**2 + 12*peggy**2 <= 95)
m.addConstr(6*jean + 12*peggy <= 82)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ringo:', ringo.x)
    print('jean:', jean.x)
    print('peggy:', peggy.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

