
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x1 = model.addVar(name='x1')  # hours worked by Jean
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy

    # Define the objective function
    model.setObjective(2.78 * x0**2 + 3.17 * x0 * x2 + 1.44 * x1**2 + 4.25 * x2**2 + 1.63 * x0 + 9.56 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x0 <= 90)
    model.addConstr(1 * x0 <= 95)
    model.addConstr(13 * x0 <= 80)
    model.addConstr(10 * x1 <= 90)
    model.addConstr(6 * x1 <= 95)
    model.addConstr(10 * x1 <= 80)
    model.addConstr(6 * x2 <= 90)
    model.addConstr(12 * x2 <= 95)
    model.addConstr(4 * x2 <= 80)
    model.addConstr(3 * x0**2 + 10 * x1**2 >= 23)
    model.addConstr(10 * x1 + 6 * x2 >= 16)
    model.addConstr(3 * x0 + 10 * x1 + 6 * x2 >= 16)
    model.addConstr(6 * x1 + 12 * x2 >= 15)
    model.addConstr(1 * x0 + 12 * x2 >= 27)
    model.addConstr(1 * x0 + 6 * x1 + 12 * x2 >= 27)
    model.addConstr(13 * x0**2 + 4 * x2**2 >= 21)
    model.addConstr(13 * x0 + 10 * x1 >= 10)
    model.addConstr(13 * x0 + 10 * x1 + 4 * x2 >= 10)
    model.addConstr(2 * x0 - 1 * x2 >= 0)
    model.addConstr(3 * x1 - 10 * x2 >= 0)
    model.addConstr(10 * x1**2 + 6 * x2**2 <= 32)
    model.addConstr(3 * x0**2 + 10 * x1**2 + 6 * x2**2 <= 35)
    model.addConstr(1 * x0 + 6 * x1 <= 72)
    model.addConstr(1 * x0**2 + 4 * x2**2 <= 95)
    model.addConstr(6 * x1 + 12 * x2 <= 82)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x0: ', x0.varValue)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
    else:
        print('No solution found')

optimize_problem()
