
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin E
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # milligrams of vitamin B2
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2") # milligrams of iron
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # grams of fat


    # Set objective function
    m.setObjective(9.26*x0**2 + 5.08*x0*x3 + 7.19*x1*x2 + 1.51*x2**2 + 9.67*x2*x3 + 9.71*x0 + 3.62*x1 + 4.16*x2 + 3.98*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(26*x0 + 18*x1 + 19*x2 + 22*x3 <= 325, "r0")
    m.addConstr(16*x0 + 28*x1 + 5*x2 + 11*x3 <= 225, "r1")
    m.addConstr(26*x0 + 19*x2 >= 41)
    m.addConstr(26*x0 + 22*x3 >= 66)
    m.addConstr(26*x0 + 18*x1 >= 41)
    m.addConstr(19*x2 + 22*x3 >= 46)
    m.addConstr(18*x1 + 22*x3 >= 29)
    m.addConstr(26*x0 + 18*x1 + 19*x2 >= 62)
    m.addConstr(26*x0**2 + 19*x2**2 + 22*x3**2 >= 62)
    m.addConstr(26*x0 + 18*x1 + 19*x2 >= 69)
    m.addConstr(26*x0 + 19*x2 + 22*x3 >= 69)
    m.addConstr(26*x0 + 18*x1 + 19*x2 + 22*x3 >= 69)
    m.addConstr(16*x0**2 + 11*x3**2 >= 22)
    m.addConstr(5*x2 + 11*x3 >= 39)
    m.addConstr(28*x1 + 5*x2 >= 37)
    m.addConstr(28*x1 + 11*x3 >= 30)
    m.addConstr(28*x1**2 + 5*x2**2 + 11*x3**2 >= 28)
    m.addConstr(16*x0 + 28*x1 + 11*x3 >= 28)
    m.addConstr(28*x1**2 + 5*x2**2 + 11*x3**2 >= 44)
    m.addConstr(16*x0 + 28*x1 + 11*x3 >= 44)
    m.addConstr(16*x0 + 28*x1 + 5*x2 + 11*x3 >= 44)
    m.addConstr(-8*x1**2 + 5*x3**2 >= 0)
    m.addConstr(5*x2 - 10*x3 >= 0)
    m.addConstr(16*x0 + 5*x2 <= 159)
    m.addConstr(16*x0**2 + 11*x3**2 <= 89)
    m.addConstr(28*x1 + 5*x2 <= 186)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
