
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
strawberries = m.addVar(vtype=GRB.INTEGER, name="strawberries")
milkshakes = m.addVar(vtype=GRB.CONTINUOUS, name="milkshakes")

# Set objective function
m.setObjective(2.92 * strawberries * milkshakes + 2.39 * milkshakes, GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * strawberries + 4 * milkshakes >= 20, "healthiness_lower_bound")
m.addConstr(11 * strawberries + 2 * milkshakes >= 12, "cost_lower_bound")
m.addConstr(-3 * strawberries + 9 * milkshakes >= 0, "constraint_3")
m.addConstr(13 * strawberries + 4 * milkshakes <= 46, "healthiness_upper_bound")
m.addConstr(11 * strawberries + 2 * milkshakes <= 37, "cost_upper_bound")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    print(f"Strawberries: {strawberries.x}")
    print(f"Milkshakes: {milkshakes.x}")
    print(f"Objective value: {m.objVal}")

