
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables: x0 (strawberries) is integer, x1 (milkshakes) is continuous
x0 = m.addVar(vtype=GRB.INTEGER, name="strawberries")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milkshakes")

# Objective function: minimize 2.92*x0*x1 + 2.39*x1
m.setObjective(2.92*x0*x1 + 2.39*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(13*x0 + 4*x1 >= 20, name="healthiness_min")
m.addConstr(13*x0 + 4*x1 <= 46, name="healthiness_max")
m.addConstr(11*x0 + 2*x1 >= 12, name="cost_min")
m.addConstr(11*x0 + 2*x1 <= 37, name="cost_max")
m.addConstr(-3*x0 + 9*x1 >= 0, name="item_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Strawberries: {x0.x}")
    print(f"Milkshakes: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
