
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="strawberries", vtype=gurobi.GRB.INTEGER)  # strawberries
    x2 = model.addVar(name="milkshakes")  # milkshakes

    # Define the objective function
    model.setObjective(2.92 * x1 * x2 + 2.39 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(13 * x1 + 4 * x2 >= 20)  # healthiness rating >= 20
    model.addConstr(11 * x1 + 2 * x2 >= 12)  # cost >= 12
    model.addConstr(-3 * x1 + 9 * x2 >= 0)  # -3x1 + 9x2 >= 0
    model.addConstr(13 * x1 + 4 * x2 <= 46)  # healthiness rating <= 46
    model.addConstr(11 * x1 + 2 * x2 <= 37)  # cost <= 37

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Strawberries: {x1.varValue}")
        print(f"Milkshakes: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
