
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, names=["Bill", "Bobby", "John", "Jean"])

    # Set objective function
    m.setObjective(1*x[0] + 7*x[1] + 7*x[2] + 2*x[3], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6.03*x[0] + 7.15*x[1] >= 27)
    m.addConstr(3.18*x[2] + 10.35*x[3] >= 53)
    m.addConstr(6.03*x[0] + 7.15*x[1] + 10.35*x[3] >= 49)
    m.addConstr(6.03*x[0] + 7.15*x[1] + 3.18*x[2] + 10.35*x[3] >= 49)
    m.addConstr(11.64*x[1] + 4.78*x[3] >= 30)
    m.addConstr(11.64*x[1] + 9.03*x[2] >= 20)
    m.addConstr(9.03*x[2] + 4.78*x[3] >= 31)
    m.addConstr(11.64*x[1] + 9.03*x[2] + 4.78*x[3] >= 29)
    m.addConstr(9.43*x[0] + 11.64*x[1] + 9.03*x[2] + 4.78*x[3] >= 29)
    m.addConstr(7*x[1] - 1*x[2] >= 0)
    m.addConstr(-7*x[1] + 7*x[3] >= 0)
    m.addConstr(4*x[0] - 10*x[3] >= 0)
    m.addConstr(6.03*x[0] + 7.15*x[1] + 3.18*x[2] <= 212)
    m.addConstr(9.43*x[0] + 9.03*x[2] + 4.78*x[3] <= 152)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")

except gp.GurobiError as e:
    print(f'Error code {e.errno}: {e.message}')
except AttributeError:
    print('Encountered an attribute error')
